<?php include 'includes/header.php'; ?>

<div class="container">
    <h1>Fans Team of the Week</h1>
    
    <?php
    // Get current game week
    $stmt = $pdo->query("SELECT * FROM voting_periods WHERE is_active = TRUE LIMIT 1");
    $currentGameWeek = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$currentGameWeek) {
        echo "<p>No active voting period at the moment.</p>";
        include 'includes/footer.php';
        exit;
    }
    
    $game_week = $currentGameWeek['game_week'];
    
    // Get top players by position with their actual vote counts
    $positions = ['GK', 'DEF', 'MID', 'FWD'];
    $team_of_week = [];
    
    foreach($positions as $position) {
        $stmt = $pdo->prepare("
            SELECT p.*, pos.name as position_name, pos.code as position_code, 
                   COUNT(v.id) as vote_count 
            FROM players p 
            JOIN positions pos ON p.position_id = pos.id 
            LEFT JOIN votes v ON p.id = v.player_id AND v.game_week = ?
            WHERE pos.code = ? AND p.game_week = ? AND p.is_active = TRUE 
            GROUP BY p.id 
            ORDER BY vote_count DESC, p.name ASC
            LIMIT 10
        ");
        $stmt->execute([$game_week, $position, $game_week]);
        $team_of_week[$position] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    // Get top coach
    $stmt = $pdo->prepare("
        SELECT c.*, COUNT(v.id) as vote_count 
        FROM coaches c 
        LEFT JOIN votes v ON c.id = v.coach_id AND v.game_week = ?
        WHERE c.game_week = ? AND c.is_active = TRUE 
        GROUP BY c.id 
        ORDER BY vote_count DESC 
        LIMIT 1
    ");
    $stmt->execute([$game_week, $game_week]);
    $top_coach = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // DYNAMIC FORMATION CALCULATION
    // Get the top voted players regardless of position (for flexible formation)
    $stmt = $pdo->prepare("
        SELECT p.*, pos.name as position_name, pos.code as position_code, 
               COUNT(v.id) as vote_count 
        FROM players p 
        JOIN positions pos ON p.position_id = pos.id 
        LEFT JOIN votes v ON p.id = v.player_id AND v.game_week = ?
        WHERE p.game_week = ? AND p.is_active = TRUE 
        GROUP BY p.id 
        ORDER BY vote_count DESC 
        LIMIT 15
    ");
    $stmt->execute([$game_week, $game_week]);
    $top_players_all = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Separate top players by position
    $top_gk = array_filter($top_players_all, function($player) {
        return $player['position_code'] === 'GK';
    });
    $top_def = array_filter($top_players_all, function($player) {
        return $player['position_code'] === 'DEF';
    });
    $top_mid = array_filter($top_players_all, function($player) {
        return $player['position_code'] === 'MID';
    });
    $top_fwd = array_filter($top_players_all, function($player) {
        return $player['position_code'] === 'FWD';
    });
    
    // Ensure we have at least one goalkeeper (non-negotiable)
    $selected_gk = array_slice($top_gk, 0, 1);
    
    // Dynamic formation calculation based on vote distribution
    $remaining_spots = 10; // 11 total - 1 GK
    
    // Calculate how many players to take from each position based on vote distribution
    $total_votes_def = array_sum(array_column($top_def, 'vote_count'));
    $total_votes_mid = array_sum(array_column($top_mid, 'vote_count'));
    $total_votes_fwd = array_sum(array_column($top_fwd, 'vote_count'));
    $total_votes_outfield = $total_votes_def + $total_votes_mid + $total_votes_fwd;
    
    if ($total_votes_outfield > 0) {
        // Calculate proportional allocation based on votes
        $def_spots = max(3, min(5, round(($total_votes_def / $total_votes_outfield) * $remaining_spots)));
        $mid_spots = max(3, min(5, round(($total_votes_mid / $total_votes_outfield) * $remaining_spots)));
        $fwd_spots = max(1, min(4, $remaining_spots - $def_spots - $mid_spots));
        
        // Adjust if totals don't add up
        $total_selected = $def_spots + $mid_spots + $fwd_spots;
        if ($total_selected != $remaining_spots) {
            // Give extra spots to the position with most votes
            if ($total_votes_def >= $total_votes_mid && $total_votes_def >= $total_votes_fwd) {
                $def_spots += ($remaining_spots - $total_selected);
            } elseif ($total_votes_mid >= $total_votes_def && $total_votes_mid >= $total_votes_fwd) {
                $mid_spots += ($remaining_spots - $total_selected);
            } else {
                $fwd_spots += ($remaining_spots - $total_selected);
            }
        }
        
        // Ensure minimum requirements
        $def_spots = max(3, min(5, $def_spots));
        $mid_spots = max(3, min(5, $mid_spots));
        $fwd_spots = max(1, min(4, $fwd_spots));
        
        // Final adjustment to ensure exactly 10 outfield players
        while (($def_spots + $mid_spots + $fwd_spots) > $remaining_spots) {
            if ($fwd_spots > 1) $fwd_spots--;
            elseif ($mid_spots > 3) $mid_spots--;
            elseif ($def_spots > 3) $def_spots--;
        }
        
        while (($def_spots + $mid_spots + $fwd_spots) < $remaining_spots) {
            if ($fwd_spots < 4) $fwd_spots++;
            elseif ($mid_spots < 5) $mid_spots++;
            elseif ($def_spots < 5) $def_spots++;
        }
    } else {
        // Fallback: Use balanced formation if no votes
        $def_spots = 4;
        $mid_spots = 4;
        $fwd_spots = 2;
    }
    
    // Select players based on calculated formation
    $selected_def = array_slice($top_def, 0, $def_spots);
    $selected_mid = array_slice($top_mid, 0, $mid_spots);
    $selected_fwd = array_slice($top_fwd, 0, $fwd_spots);
    
    $formation = "$def_spots-$mid_spots-$fwd_spots";
    $total_players_team = 1 + $def_spots + $mid_spots + $fwd_spots; // +1 for GK
    
    // Calculate total votes for the selected team
    $team_total_votes = 0;
    if (!empty($selected_gk)) $team_total_votes += $selected_gk[0]['vote_count'];
    foreach ($selected_def as $player) $team_total_votes += $player['vote_count'];
    foreach ($selected_mid as $player) $team_total_votes += $player['vote_count'];
    foreach ($selected_fwd as $player) $team_total_votes += $player['vote_count'];
    if ($top_coach) $team_total_votes += $top_coach['vote_count'];
    ?>
    
    <div class="formation-info">
        <h2>Game Week <?php echo $game_week; ?> - <?php echo $formation; ?> Formation</h2>
        <p>Dynamic formation based on fan votes distribution</p>
        <div class="team-stats">
            <div class="stat-item">
                <span>Total Team Votes:</span>
                <strong><?php echo $team_total_votes; ?></strong>
            </div>
            <div class="stat-item">
                <span>Players in Team:</span>
                <strong><?php echo $total_players_team; ?> + 1 coach</strong>
            </div>
        </div>
    </div>
    
    <!-- Formation Visualization -->
    <div class="formation-display">
        <!-- Coach -->
        <div class="formation-line coach-line">
            <?php if($top_coach): ?>
            <div class="formation-player coach">
                <h4><?php echo $top_coach['name']; ?></h4>
                <p>Manager - <?php echo $top_coach['team']; ?></p>
                <small><?php echo $top_coach['vote_count']; ?> votes</small>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Forwards -->
        <div class="formation-line">
            <?php foreach($selected_fwd as $forward): ?>
            <div class="formation-player forward">
                <img src="<?php echo $forward['photo'] ?: 'assets/default-player.jpg'; ?>" 
                     alt="<?php echo $forward['name']; ?>"
                     onerror="this.src='assets/default-player.jpg'">
                <h4><?php echo $forward['name']; ?></h4>
                <p><?php echo $forward['team']; ?></p>
                <small><?php echo $forward['vote_count']; ?> votes</small>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Midfielders -->
        <div class="formation-line">
            <?php foreach($selected_mid as $midfielder): ?>
            <div class="formation-player midfielder">
                <img src="<?php echo $midfielder['photo'] ?: 'assets/default-player.jpg'; ?>" 
                     alt="<?php echo $midfielder['name']; ?>"
                     onerror="this.src='assets/default-player.jpg'">
                <h4><?php echo $midfielder['name']; ?></h4>
                <p><?php echo $midfielder['team']; ?></p>
                <small><?php echo $midfielder['vote_count']; ?> votes</small>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Defenders -->
        <div class="formation-line">
            <?php foreach($selected_def as $defender): ?>
            <div class="formation-player defender">
                <img src="<?php echo $defender['photo'] ?: 'assets/default-player.jpg'; ?>" 
                     alt="<?php echo $defender['name']; ?>"
                     onerror="this.src='assets/default-player.jpg'">
                <h4><?php echo $defender['name']; ?></h4>
                <p><?php echo $defender['team']; ?></p>
                <small><?php echo $defender['vote_count']; ?> votes</small>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Goalkeeper -->
        <div class="formation-line">
            <?php if(!empty($selected_gk)): ?>
            <div class="formation-player goalkeeper">
                <img src="<?php echo $selected_gk[0]['photo'] ?: 'assets/default-player.jpg'; ?>" 
                     alt="<?php echo $selected_gk[0]['name']; ?>"
                     onerror="this.src='assets/default-player.jpg'">
                <h4><?php echo $selected_gk[0]['name']; ?></h4>
                <p><?php echo $selected_gk[0]['team']; ?></p>
                <small><?php echo $selected_gk[0]['vote_count']; ?> votes</small>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Color Legend -->
    <div class="formation-explanation">
        <h3>Formation Color Guide</h3>
        <div class="formation-legend">
            <div class="legend-item">
                <div class="legend-color goalkeeper"></div>
                <span>Goalkeeper</span>
            </div>
            <div class="legend-item">
                <div class="legend-color defender"></div>
                <span>Defender</span>
            </div>
            <div class="legend-item">
                <div class="legend-color midfielder"></div>
                <span>Midfielder</span>
            </div>
            <div class="legend-item">
                <div class="legend-color forward"></div>
                <span>Forward</span>
            </div>
            <div class="legend-item">
                <div class="legend-color coach"></div>
                <span>Coach</span>
            </div>
        </div>
    </div>
    
    <!-- Formation Explanation -->
    <div class="formation-explanation">
        <h3>How This Formation Was Chosen</h3>
        <div class="explanation-grid">
            <div class="explanation-item">
                <h4>Defenders: <?php echo count($selected_def); ?></h4>
                <p>Based on <?php echo $total_votes_def; ?> total votes for defenders</p>
            </div>
            <div class="explanation-item">
                <h4>Midfielders: <?php echo count($selected_mid); ?></h4>
                <p>Based on <?php echo $total_votes_mid; ?> total votes for midfielders</p>
            </div>
            <div class="explanation-item">
                <h4>Forwards: <?php echo count($selected_fwd); ?></h4>
                <p>Based on <?php echo $total_votes_fwd; ?> total votes for forwards</p>
            </div>
        </div>
    </div>
    
    <!-- Full Team List -->
    <div class="full-team">
        <h3>Complete Team of the Week</h3>
        <div class="team-grid">
            <div class="position-group">
                <h4>Goalkeeper</h4>
                <?php foreach($team_of_week['GK'] as $player): ?>
                <div class="team-player <?php echo in_array($player, $selected_gk) ? 'selected' : ''; ?>">
                    <img src="<?php echo $player['photo'] ?: 'assets/default-player.jpg'; ?>" 
                         alt="<?php echo $player['name']; ?>"
                         onerror="this.src='assets/default-player.jpg'">
                    <div class="player-info">
                        <strong><?php echo $player['name']; ?></strong>
                        <span><?php echo $player['team']; ?></span>
                        <small><?php echo $player['vote_count']; ?> votes</small>
                    </div>
                    <?php if(in_array($player, $selected_gk)): ?>
                    <span class="in-team-badge">In Team</span>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="position-group">
                <h4>Defenders</h4>
                <?php foreach($team_of_week['DEF'] as $player): ?>
                <div class="team-player <?php echo in_array($player, $selected_def) ? 'selected' : ''; ?>">
                    <img src="<?php echo $player['photo'] ?: 'assets/default-player.jpg'; ?>" 
                         alt="<?php echo $player['name']; ?>"
                         onerror="this.src='assets/default-player.jpg'">
                    <div class="player-info">
                        <strong><?php echo $player['name']; ?></strong>
                        <span><?php echo $player['team']; ?></span>
                        <small><?php echo $player['vote_count']; ?> votes</small>
                    </div>
                    <?php if(in_array($player, $selected_def)): ?>
                    <span class="in-team-badge">In Team</span>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="position-group">
                <h4>Midfielders</h4>
                <?php foreach($team_of_week['MID'] as $player): ?>
                <div class="team-player <?php echo in_array($player, $selected_mid) ? 'selected' : ''; ?>">
                    <img src="<?php echo $player['photo'] ?: 'assets/default-player.jpg'; ?>" 
                         alt="<?php echo $player['name']; ?>"
                         onerror="this.src='assets/default-player.jpg'">
                    <div class="player-info">
                        <strong><?php echo $player['name']; ?></strong>
                        <span><?php echo $player['team']; ?></span>
                        <small><?php echo $player['vote_count']; ?> votes</small>
                    </div>
                    <?php if(in_array($player, $selected_mid)): ?>
                    <span class="in-team-badge">In Team</span>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="position-group">
                <h4>Forwards</h4>
                <?php foreach($team_of_week['FWD'] as $player): ?>
                <div class="team-player <?php echo in_array($player, $selected_fwd) ? 'selected' : ''; ?>">
                    <img src="<?php echo $player['photo'] ?: 'assets/default-player.jpg'; ?>" 
                         alt="<?php echo $player['name']; ?>"
                         onerror="this.src='assets/default-player.jpg'">
                    <div class="player-info">
                        <strong><?php echo $player['name']; ?></strong>
                        <span><?php echo $player['team']; ?></span>
                        <small><?php echo $player['vote_count']; ?> votes</small>
                    </div>
                    <?php if(in_array($player, $selected_fwd)): ?>
                    <span class="in-team-badge">In Team</span>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<style>
.formation-info {
    text-align: center;
    margin: 2rem 0;
    background: white;
    padding: 2rem;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.team-stats {
    display: flex;
    justify-content: center;
    gap: 3rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid #e0e0e0;
}

.team-stats .stat-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
}

.team-stats .stat-item span {
    color: var(--gray);
    font-size: 0.9rem;
}

.team-stats .stat-item strong {
    color: var(--primary-blue);
    font-size: 1.2rem;
}

.formation-display {
    background: white;
    padding: 2rem;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    margin: 2rem 0;
    background: linear-gradient(135deg, #f8f9fa, #e9ecef);
    overflow-x: auto; /* Allow horizontal scrolling on small screens */
}

/* FIXED: Formation lines - centered and no wrapping */
.formation-line {
    display: flex;
    justify-content: center;
    gap: 1rem;
    margin: 1.5rem 0;
    flex-wrap: nowrap; /* Prevent wrapping */
    min-width: min-content; /* Ensure line doesn't shrink below content */
    width: 100%;
}

.coach-line {
    margin-bottom: 3rem;
}

/* FIXED: Formation player cards - maintain size and structure */
.formation-player {
    background: white;
    padding: 1rem;
    border-radius: 10px;
    text-align: center;
    min-width: 140px; /* Fixed minimum width */
    max-width: 160px; /* Fixed maximum width */
    width: 140px; /* Fixed width */
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
    border: 2px solid transparent;
    flex-shrink: 0; /* Prevent shrinking */
}

.formation-player:hover {
    transform: translateY(-2px);
}

/* FIXED: Coach styling with better contrast */
.formation-player.coach {
    background: linear-gradient(135deg, #f39c12, #e67e22);
    color: white;
    border: 2px solid #e67e22;
}

/* FIXED: Goalkeeper - Changed to blue with white text */
.formation-player.goalkeeper {
    background: linear-gradient(135deg, #3498db, #2980b9);
    color: white;
    border: 2px solid #2980b9;
}

/* FIXED: Defender - Changed to green with white text */
.formation-player.defender {
    background: linear-gradient(135deg, #27ae60, #219653);
    color: white;
    border: 2px solid #219653;
}

/* FIXED: Midfielder - Better contrast */
.formation-player.midfielder {
    background: linear-gradient(135deg, #9b59b6, #8e44ad);
    color: white;
    border: 2px solid #8e44ad;
}

/* FIXED: Forward - Better contrast */
.formation-player.forward {
    background: linear-gradient(135deg, #e74c3c, #c0392b);
    color: white;
    border: 2px solid #c0392b;
}

.formation-player img {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    object-fit: cover;
    margin-bottom: 0.8rem;
    border: 3px solid rgba(255,255,255,0.3);
}

.formation-player h4 {
    margin: 0.5rem 0;
    font-size: 0.9rem;
    font-weight: 600;
    line-height: 1.2;
}

.formation-player p {
    margin: 0.3rem 0;
    font-size: 0.8rem;
    opacity: 0.9;
    line-height: 1.2;
}

.formation-player small {
    font-size: 0.7rem;
    opacity: 0.8;
}

.formation-explanation {
    background: white;
    padding: 2rem;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    margin: 2rem 0;
}

.explanation-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    margin-top: 1rem;
}

.explanation-item {
    text-align: center;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 8px;
    border-left: 4px solid var(--primary-blue);
}

.explanation-item h4 {
    color: var(--primary-blue);
    margin-bottom: 0.5rem;
}

.explanation-item p {
    color: var(--gray);
    font-size: 0.9rem;
}

.full-team {
    background: white;
    padding: 2rem;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    margin-top: 3rem;
}

.team-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
    margin-top: 1.5rem;
}

.position-group {
    border: 1px solid #e0e0e0;
    border-radius: 10px;
    padding: 1.5rem;
    background: #fafafa;
}

.position-group h4 {
    margin-bottom: 1rem;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid var(--primary-blue);
    color: var(--primary-blue);
}

.team-player {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.8rem;
    border-radius: 5px;
    margin-bottom: 0.5rem;
    transition: background 0.3s ease;
    position: relative;
}

.team-player:hover {
    background: #f0f0f0;
}

/* FIXED: Players in the team now have green background */
.team-player.selected {
    background: linear-gradient(135deg, #e8f5e8, #d4edda);
    border-left: 4px solid #27ae60;
    border-radius: 8px;
}

.team-player img {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    object-fit: cover;
}

.player-info {
    flex: 1;
}

.player-info strong {
    display: block;
    margin-bottom: 0.2rem;
    font-weight: 600;
}

.player-info span {
    color: #666;
    font-size: 0.9rem;
    display: block;
    margin-bottom: 0.2rem;
}

.player-info small {
    color: var(--primary-blue);
    font-weight: bold;
    font-size: 0.8rem;
}

/* FIXED: In-team badge with better green color */
.in-team-badge {
    background: #27ae60;
    color: white;
    padding: 0.3rem 0.8rem;
    border-radius: 20px;
    font-size: 0.7rem;
    font-weight: bold;
    box-shadow: 0 2px 5px rgba(39, 174, 96, 0.3);
}

/* NEW: Color legend for formation */
.formation-legend {
    display: flex;
    justify-content: center;
    gap: 2rem;
    margin-top: 1rem;
    flex-wrap: wrap;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.9rem;
    color: var(--gray);
}

.legend-color {
    width: 20px;
    height: 20px;
    border-radius: 50%;
    border: 2px solid #fff;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

.legend-color.goalkeeper { background: #3498db; }
.legend-color.defender { background: #27ae60; }
.legend-color.midfielder { background: #9b59b6; }
.legend-color.forward { background: #e74c3c; }
.legend-color.coach { background: #f39c12; }

/* FIXED: Responsive scaling for formation */
@media (max-width: 1200px) {
    .formation-player {
        min-width: 130px;
        max-width: 140px;
        width: 130px;
        padding: 0.8rem;
    }
    
    .formation-player img {
        width: 45px;
        height: 45px;
    }
    
    .formation-player h4 {
        font-size: 0.85rem;
    }
}

@media (max-width: 992px) {
    .formation-player {
        min-width: 120px;
        max-width: 130px;
        width: 120px;
        padding: 0.7rem;
    }
    
    .formation-player img {
        width: 40px;
        height: 40px;
    }
    
    .formation-player h4 {
        font-size: 0.8rem;
    }
    
    .formation-line {
        gap: 0.8rem;
    }
}

@media (max-width: 768px) {
    .formation-display {
        padding: 1.5rem;
        overflow-x: auto; /* Enable horizontal scrolling */
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    
    .formation-line {
        gap: 0.6rem;
        margin: 1rem 0;
        justify-content: center; /* Always center */
        flex-wrap: nowrap;
        width: auto; /* Auto width for centering */
    }
    
    .formation-player {
        min-width: 110px;
        max-width: 120px;
        width: 110px;
        padding: 0.6rem;
    }
    
    .formation-player img {
        width: 35px;
        height: 35px;
    }
    
    .formation-player h4 {
        font-size: 0.75rem;
    }
    
    .formation-player p {
        font-size: 0.7rem;
    }
    
    .formation-player small {
        font-size: 0.65rem;
    }
    
    .team-stats {
        flex-direction: column;
        gap: 1rem;
    }
    
    .explanation-grid {
        grid-template-columns: 1fr;
    }
    
    .formation-legend {
        gap: 1rem;
    }
}

@media (max-width: 576px) {
    .formation-display {
        padding: 1rem;
        margin: 1rem 0;
    }
    
    .formation-line {
        gap: 0.5rem;
        margin: 0.8rem 0;
    }
    
    .formation-player {
        min-width: 100px;
        max-width: 110px;
        width: 100px;
        padding: 0.5rem;
    }
    
    .formation-player img {
        width: 30px;
        height: 30px;
    }
    
    .formation-player h4 {
        font-size: 0.7rem;
    }
    
    .formation-player p {
        font-size: 0.65rem;
    }
}

/* Extra small devices */
@media (max-width: 400px) {
    .formation-player {
        min-width: 90px;
        max-width: 100px;
        width: 90px;
        padding: 0.4rem;
    }
    
    .formation-player img {
        width: 28px;
        height: 28px;
    }
    
    .formation-player h4 {
        font-size: 0.65rem;
    }
    
    .formation-line {
        gap: 0.4rem;
    }
}

/* FIXED: Formation structure maintenance - Always centered */
.formation-structure {
    display: flex;
    flex-direction: column;
    align-items: center;
    width: 100%;
}

.formation-line.coach-line {
    margin-bottom: 2rem;
}

/* Ensure formation lines don't wrap and are centered */
.formation-line:not(.coach-line) {
    flex-wrap: nowrap;
    overflow-x: visible;
}

/* Center the entire formation container */
.formation-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    width: 100%;
}

/* Scroll hint for mobile */
.formation-display::-webkit-scrollbar {
    height: 6px;
}

.formation-display::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}

.formation-display::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 3px;
}

.formation-display::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Mobile scroll hint - removed since we're centering */
/* .formation-display::after {
    display: none;
} */

/* Center alignment for all screen sizes */
.formation-line {
    display: flex;
    justify-content: center;
    align-items: center;
}

/* Ensure coach is always centered */
.coach-line .formation-player {
    margin: 0 auto;
}

/* Special handling for odd number of players */
.formation-line:not(.coach-line) {
    display: flex;
    justify-content: center;
    align-items: center;
}

/* Make sure the formation display itself is centered */
.formation-display-wrapper {
    display: flex;
    justify-content: center;
    width: 100%;
}

/* For very wide formations, ensure they stay centered */
@media (min-width: 1200px) {
    .formation-line {
        max-width: 1200px;
        margin-left: auto;
        margin-right: auto;
    }
}

/* Perfect centering solution */
.formation-line {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-wrap: nowrap;
    width: fit-content;
    margin-left: auto;
    margin-right: auto;
}

/* Ensure the formation display container centers its children */
.formation-display {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
}
</style>

<?php include 'includes/footer.php'; ?>