<?php include 'includes/header.php'; ?>

<div class="container">
    <section class="hero">
        <div class="hero-content">
            <h1>Vote for Your Team of the Week</h1>
            <p>Select your favorite players and coach for this game week</p>
            <?php if(isset($_SESSION['user_id'])): ?>
                <a href="vote.php" class="btn btn-primary">Vote Now</a>
            <?php else: ?>
                <a href="register.php" class="btn btn-primary">Join Now to Vote</a>
            <?php endif; ?>
        </div>
    </section>

    <section class="features">
        <div class="feature-grid">
            <div class="feature-card">
                <i class="fas fa-vote-yea"></i>
                <h3>Vote Weekly</h3>
                <p>Select your team of 11 players and 1 coach every game week</p>
            </div>
            <div class="feature-card">
                <i class="fas fa-trophy"></i>
                <h3>Leaderboard</h3>
                <p>See which players and coaches are getting the most votes</p>
            </div>
            <div class="feature-card">
                <i class="fas fa-users"></i>
                <h3>Team of Week</h3>
                <p>View the fans' selected team with dynamic formations</p>
            </div>
        </div>
    </section>

    <?php
    // Get current game week
    $stmt = $pdo->query("SELECT * FROM voting_periods WHERE is_active = TRUE LIMIT 1");
    $currentGameWeek = $stmt->fetch(PDO::FETCH_ASSOC);
    ?>

    <section class="current-voting">
        <h2>Current Voting Period</h2>
        <?php if($currentGameWeek): ?>
            <div class="voting-info">
                <p><strong>Game Week:</strong> <?php echo $currentGameWeek['game_week']; ?></p>
                <p><strong>Ends:</strong> <?php echo date('F j, Y g:i A', strtotime($currentGameWeek['end_date'])); ?></p>
            </div>
        <?php else: ?>
            <p>No active voting period at the moment.</p>
        <?php endif; ?>
    </section>
</div>

<?php include 'includes/footer.php'; ?>