<?php
session_start();
require_once 'database.php';

// Get site settings with error handling
$settings = [
    'logo_type' => 'text',
    'logo_text' => 'FantasyVote',
    'logo_image' => '',
    'footer_text' => 'Vote for your favorite players and coaches every game week!'
];

try {
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM site_settings");
    if ($stmt) {
        $settings_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach($settings_data as $setting) {
            $settings[$setting['setting_key']] = $setting['setting_value'];
        }
    }
} catch(Exception $e) {
    // Use defaults if settings table doesn't exist or query fails
    error_log("Site settings error: " . $e->getMessage());
}

$logo_type = $settings['logo_type'];
$logo_text = $settings['logo_text'];
$logo_image = $settings['logo_image'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fantasy Vote - Team of the Week</title>
    <link rel="stylesheet" href="css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-logo">
                <a href="index.php">
                    <?php if($logo_type === 'image' && !empty($logo_image)): ?>
                        <img src="<?php echo $logo_image; ?>" alt="<?php echo htmlspecialchars($logo_text); ?>" 
                             style="height: 40px; max-width: 200px; object-fit: contain;"
                             onerror="this.style.display='none'; document.getElementById('fallbackLogo').style.display='inline-block';">
                        <span id="fallbackLogo" style="display: none;"><?php echo htmlspecialchars($logo_text); ?></span>
                    <?php else: ?>
                        <?php echo htmlspecialchars($logo_text); ?>
                    <?php endif; ?>
                </a>
            </div>
            
            <div class="menu-toggle">
                <span></span>
                <span></span>
                <span></span>
            </div>
            
            <div class="nav-menu">
                <a href="index.php"><i class="fas fa-home"></i> Home</a>
                <a href="vote.php"><i class="fas fa-vote-yea"></i> Vote</a>
                <a href="leaderboard.php"><i class="fas fa-trophy"></i> Leaderboard</a>
                <a href="team-of-week.php"><i class="fas fa-users"></i> Team of Week</a>
                <?php if(isset($_SESSION['user_id'])): ?>
                <a href="wallet.php"><i class="fas fa-wallet"></i> My Wallet</a>
                    <a href="profile.php"><i class="fas fa-user"></i> My Profile</a>
                    <?php if(isset($_SESSION['admin_logged_in'])): ?>
                        <a href="admin/index.php"><i class="fas fa-cog"></i> Admin</a>
                    <?php endif; ?>
                    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout (<?php echo htmlspecialchars($_SESSION['username']); ?>)</a>
                <?php else: ?>
                    <a href="login.php"><i class="fas fa-sign-in-alt"></i> Login</a>
                    <a href="register.php"><i class="fas fa-user-plus"></i> Register</a>
                <?php endif; ?>
            </div>
        </div>
    </nav>
    <main>