</main>
    
<?php
// Get footer text from settings
$footer_text = 'Vote for your favorite players and coaches every game week!';
try {
    $stmt = $pdo->query("SELECT setting_value FROM site_settings WHERE setting_key = 'footer_text'");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result && !empty($result['setting_value'])) {
        $footer_text = $result['setting_value'];
    }
} catch(Exception $e) {
    // Use default if error
}
$current_year = date('Y');
?>

<footer style="background: linear-gradient(135deg, #0d47a1, #1a73e8); color: white; padding: 3rem 0; margin-top: 4rem;">
    <div class="container" style="max-width: 1200px; margin: 0 auto; padding: 0 1rem; text-align: center;">
        <div style="display: inline-block; background: rgba(255,255,255,0.1); padding: 1rem 2rem; border-radius: 10px;">
            <p style="margin: 0; font-size: 1.1rem; font-weight: 600; color: white;">&copy; <?php echo $current_year; ?> FantasyVote. All rights reserved.</p>
            <p style="margin: 0.5rem 0 0 0; opacity: 0.9; color: white;"><?php echo htmlspecialchars($footer_text); ?></p>
        </div>
        <div style="margin-top: 1.5rem;">
            <a href="index.php" style="color: white; margin: 0 1rem; text-decoration: none; transition: opacity 0.3s;">Home</a>
            <a href="vote.php" style="color: white; margin: 0 1rem; text-decoration: none; transition: opacity 0.3s;">Vote</a>
            <a href="leaderboard.php" style="color: white; margin: 0 1rem; text-decoration: none; transition: opacity 0.3s;">Leaderboard</a>
            <a href="team-of-week.php" style="color: white; margin: 0 1rem; text-decoration: none; transition: opacity 0.3s;">Team of Week</a>
        </div>
    </div>
</footer>

<!-- Toast Notifications -->
<div id="toast-container" style="position: fixed; top: 20px; right: 20px; z-index: 10000;"></div>

<script>
// Toast notification system
function showToast(message, type = 'success') {
    const toast = document.createElement('div');
    toast.style.cssText = `
        background: ${type === 'success' ? '#34a853' : '#ea4335'};
        color: white;
        padding: 1rem 1.5rem;
        border-radius: 8px;
        margin-bottom: 0.5rem;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        animation: slideInRight 0.3s ease;
        max-width: 300px;
        word-wrap: break-word;
        font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
    `;
    toast.textContent = message;
    
    const container = document.getElementById('toast-container');
    container.appendChild(toast);
    
    setTimeout(() => {
        toast.style.animation = 'slideOutRight 0.3s ease';
        setTimeout(() => toast.remove(), 300);
    }, 4000);
}

// Add CSS for animations
const style = document.createElement('style');
style.textContent = `
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes slideOutRight {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
`;
document.head.appendChild(style);

// Show notifications from PHP session
<?php if(isset($_SESSION['success'])): ?>
    showToast('<?php echo addslashes($_SESSION['success']); ?>', 'success');
    <?php unset($_SESSION['success']); ?>
<?php endif; ?>

<?php if(isset($_SESSION['error'])): ?>
    showToast('<?php echo addslashes($_SESSION['error']); ?>', 'error');
    <?php unset($_SESSION['error']); ?>
<?php endif; ?>
</script>

</body>
</html>