<?php
include 'includes/header.php';

if(!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Handle coin purchase
if($_POST && isset($_POST['purchase_coins'])) {
    $amount_zmw = floatval($_POST['amount_zmw']);
    $amount_coins = $amount_zmw * 10; // 1 ZMW = 10 ZIT Coins
    
    // Generate unique transaction reference
    $tx_ref = 'ZIT_' . time() . '_' . $user_id;
    
    // Save pending transaction
    $stmt = $pdo->prepare("INSERT INTO payment_transactions (user_id, flutterwave_ref, amount_zmw, amount_coins, status) VALUES (?, ?, ?, ?, 'pending')");
    $stmt->execute([$user_id, $tx_ref, $amount_zmw, $amount_coins]);
    
    // Flutterwave payment data
    $payment_data = [
        'public_key' => 'YOUR_FLUTTERWAVE_PUBLIC_KEY',
        'tx_ref' => $tx_ref,
        'amount' => $amount_zmw,
        'currency' => 'ZMW',
        'payment_options' => 'card,mobilemoneyzambia',
        'redirect_url' => 'https://yoursite.com/payment-callback.php',
        'customer' => [
            'email' => $_SESSION['email'],
            'name' => $_SESSION['username']
        ],
        'customizations' => [
            'title' => 'ZIT Coins Purchase',
            'description' => "Purchase of {$amount_coins} ZIT Coins",
            'logo' => 'https://yoursite.com/logo.png'
        ]
    ];
}
?>

<div class="container">
    <h1>Buy ZIT Coins</h1>
    
    <div class="purchase-options">
        <div class="purchase-info">
            <h2>Exchange Rate</h2>
            <div class="rate-card">
                <strong>1 ZMW = 10 ZIT Coins</strong>
                <p>Use ZIT Coins to vote for your favorite players and coaches</p>
            </div>
        </div>
        
        <div class="purchase-form">
            <h2>Select Amount</h2>
            <form method="POST" id="purchaseForm">
                <div class="amount-options">
                    <div class="amount-option" data-amount="10">
                        <input type="radio" name="amount_zmw" value="10" id="amount10">
                        <label for="amount10">
                            <strong>10 ZMW</strong>
                            <span>100 ZIT Coins</span>
                        </label>
                    </div>
                    
                    <div class="amount-option" data-amount="25">
                        <input type="radio" name="amount_zmw" value="25" id="amount25">
                        <label for="amount25">
                            <strong>25 ZMW</strong>
                            <span>250 ZIT Coins</span>
                        </label>
                    </div>
                    
                    <div class="amount-option" data-amount="50">
                        <input type="radio" name="amount_zmw" value="50" id="amount50">
                        <label for="amount50">
                            <strong>50 ZMW</strong>
                            <span>500 ZIT Coins</span>
                        </label>
                    </div>
                    
                    <div class="amount-option" data-amount="100">
                        <input type="radio" name="amount_zmw" value="100" id="amount100">
                        <label for="amount100">
                            <strong>100 ZMW</strong>
                            <span>1000 ZIT Coins</span>
                        </label>
                    </div>
                </div>
                
                <div class="custom-amount" style="margin-top: 1rem;">
                    <label>Or enter custom amount:</label>
                    <input type="number" name="custom_amount" id="customAmount" min="1" placeholder="Enter amount in ZMW" onchange="updateCustomCoins(this.value)">
                    <small id="customCoinsDisplay">0 ZIT Coins</small>
                </div>
                
                <div class="purchase-summary" style="margin-top: 1.5rem; padding: 1rem; background: #f8f9fa; border-radius: 8px; display: none;" id="purchaseSummary">
                    <h3>Purchase Summary</h3>
                    <div class="summary-item">
                        <span>Amount:</span>
                        <strong id="summaryAmount">0 ZMW</strong>
                    </div>
                    <div class="summary-item">
                        <span>You get:</span>
                        <strong id="summaryCoins">0 ZIT Coins</strong>
                    </div>
                </div>
                
                <button type="submit" name="purchase_coins" class="btn btn-primary" style="margin-top: 1.5rem; width: 100%;" disabled id="purchaseButton">
                    <i class="fas fa-lock"></i> Proceed to Payment
                </button>
            </form>
        </div>
    </div>
</div>

<style>
.purchase-options {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 3rem;
    margin: 2rem 0;
}

.rate-card {
    background: linear-gradient(135deg, #27ae60, #219653);
    color: white;
    padding: 2rem;
    border-radius: 10px;
    text-align: center;
    margin-top: 1rem;
}

.amount-options {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.amount-option input[type="radio"] {
    display: none;
}

.amount-option label {
    display: block;
    padding: 1.5rem;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

.amount-option input[type="radio"]:checked + label {
    border-color: #1a73e8;
    background: #e8f0fe;
}

.amount-option label strong {
    display: block;
    font-size: 1.2rem;
    margin-bottom: 0.5rem;
}

.amount-option label span {
    color: #666;
    font-size: 0.9rem;
}

.summary-item {
    display: flex;
    justify-content: space-between;
    margin: 0.5rem 0;
}

@media (max-width: 768px) {
    .purchase-options {
        grid-template-columns: 1fr;
    }
    
    .amount-options {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
// Handle amount selection
document.querySelectorAll('.amount-option input[type="radio"]').forEach(radio => {
    radio.addEventListener('change', function() {
        updatePurchaseSummary(this.value);
    });
});

function updateCustomCoins(amount) {
    const coins = amount * 10;
    document.getElementById('customCoinsDisplay').textContent = coins + ' ZIT Coins';
    
    // Set custom amount as selected
    document.querySelectorAll('.amount-option input[type="radio"]').forEach(radio => {
        radio.checked = false;
    });
    
    updatePurchaseSummary(amount);
}

function updatePurchaseSummary(amount) {
    if (amount > 0) {
        const coins = amount * 10;
        document.getElementById('summaryAmount').textContent = amount + ' ZMW';
        document.getElementById('summaryCoins').textContent = coins + ' ZIT Coins';
        document.getElementById('purchaseSummary').style.display = 'block';
        document.getElementById('purchaseButton').disabled = false;
        
        // Set the actual form value
        document.querySelector('input[name="amount_zmw"]').value = amount;
    } else {
        document.getElementById('purchaseSummary').style.display = 'none';
        document.getElementById('purchaseButton').disabled = true;
    }
}

// Initialize
document.addEventListener('DOMContentLoaded', function() {
    // Add hidden input for custom amount handling
    const form = document.getElementById('purchaseForm');
    const hiddenInput = document.createElement('input');
    hiddenInput.type = 'hidden';
    hiddenInput.name = 'amount_zmw';
    hiddenInput.value = '';
    form.appendChild(hiddenInput);
});
</script>

<?php include 'includes/footer.php'; ?>