<?php include 'includes/header.php'; ?>

<div class="container">
    <h1>Leaderboard</h1>
    <p class="subtitle">Most Voted Players and Coaches</p>
    
    <?php
    // Get current game week
    $stmt = $pdo->query("SELECT * FROM voting_periods WHERE is_active = TRUE LIMIT 1");
    $currentGameWeek = $stmt->fetch(PDO::FETCH_ASSOC);
    $game_week = $currentGameWeek ? $currentGameWeek['game_week'] : 1;
    ?>
    
    <div class="leaderboard-tabs">
        <button class="tab-btn active" onclick="openTab('players')">Players</button>
        <button class="tab-btn" onclick="openTab('coaches')">Coaches</button>
    </div>
    
    <div id="players" class="tab-content active">
        <h2>Top Players - Game Week <?php echo $game_week; ?></h2>
        
        <?php
        $stmt = $pdo->prepare("
            SELECT p.*, pos.name as position, COUNT(v.id) as vote_count 
            FROM players p 
            LEFT JOIN votes v ON p.id = v.player_id AND v.game_week = ?
            JOIN positions pos ON p.position_id = pos.id 
            WHERE p.game_week = ? AND p.is_active = TRUE 
            GROUP BY p.id 
            ORDER BY vote_count DESC, p.name ASC
        ");
        $stmt->execute([$game_week, $game_week]);
        $players = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>
        
        <table class="leaderboard-table">
            <thead>
                <tr>
                    <th>Rank</th>
                    <th>Player</th>
                    <th>Position</th>
                    <th>Team</th>
                    <th>Votes</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($players as $index => $player): ?>
                <tr>
                    <td><?php echo $index + 1; ?></td>
                    <td>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <img src="<?php echo $player['photo'] ?: 'assets/default-player.jpg'; ?>" 
                                 alt="<?php echo $player['name']; ?>" 
                                 style="width: 40px; height: 40px; border-radius: 50%;">
                            <?php echo $player['name']; ?>
                        </div>
                    </td>
                    <td><?php echo $player['position']; ?></td>
                    <td><?php echo $player['team']; ?></td>
                    <td><strong><?php echo $player['vote_count']; ?></strong></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <div id="coaches" class="tab-content">
        <h2>Top Coaches - Game Week <?php echo $game_week; ?></h2>
        
        <?php
        $stmt = $pdo->prepare("
            SELECT c.*, COUNT(v.id) as vote_count 
            FROM coaches c 
            LEFT JOIN votes v ON c.id = v.coach_id AND v.game_week = ?
            WHERE c.game_week = ? AND c.is_active = TRUE 
            GROUP BY c.id 
            ORDER BY vote_count DESC, c.name ASC
        ");
        $stmt->execute([$game_week, $game_week]);
        $coaches = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>
        
        <table class="leaderboard-table">
            <thead>
                <tr>
                    <th>Rank</th>
                    <th>Coach</th>
                    <th>Team</th>
                    <th>Votes</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($coaches as $index => $coach): ?>
                <tr>
                    <td><?php echo $index + 1; ?></td>
                    <td>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <img src="<?php echo $coach['photo'] ?: 'assets/default-coach.jpg'; ?>" 
                                 alt="<?php echo $coach['name']; ?>" 
                                 style="width: 40px; height: 40px; border-radius: 50%;">
                            <?php echo $coach['name']; ?>
                        </div>
                    </td>
                    <td><?php echo $coach['team']; ?></td>
                    <td><strong><?php echo $coach['vote_count']; ?></strong></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function openTab(tabName) {
    const tabcontents = document.getElementsByClassName("tab-content");
    const tabbuttons = document.getElementsByClassName("tab-btn");
    
    for (let i = 0; i < tabcontents.length; i++) {
        tabcontents[i].classList.remove('active');
    }
    
    for (let i = 0; i < tabbuttons.length; i++) {
        tabbuttons[i].classList.remove('active');
    }
    
    document.getElementById(tabName).classList.add('active');
    event.currentTarget.classList.add('active');
}
</script>

<style>
.leaderboard-tabs {
    margin: 2rem 0;
    border-bottom: 2px solid #e0e0e0;
}

.tab-btn {
    background: none;
    border: none;
    padding: 1rem 2rem;
    font-size: 1rem;
    cursor: pointer;
    border-bottom: 3px solid transparent;
}

.tab-btn.active {
    border-bottom: 3px solid var(--primary);
    color: var(--primary);
    font-weight: bold;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}
</style>

<?php include 'includes/footer.php'; ?>