<?php
session_start();
require_once '../includes/database.php';

if(!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - FantasyVote</title>
    <link rel="stylesheet" href="../css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* Define CSS variables if not present */
        :root {
            --primary-blue: #1a73e8;
            --secondary-blue: #4285f4;
            --dark-blue: #0d47a1;
            --light-blue: #e8f0fe;
            --accent-blue: #34a853;
            --warning: #fbbc05;
            --danger: #ea4335;
            --light: #f8f9fa;
            --dark: #202124;
            --gray: #5f6368;
            --white: #ffffff;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
        }

        .admin-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .admin-nav {
            background: linear-gradient(135deg, #0d47a1, #1a73e8);
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .admin-nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }
        
        .admin-menu a {
            color: white;
            text-decoration: none;
            margin-left: 1.5rem;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            transition: background 0.3s ease;
            font-weight: 500;
        }
        
        .admin-menu a:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin: 2rem 0;
        }
        
        .stat-card {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #1a73e8;
            transition: transform 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-number {
            font-size: 2.5rem;
            font-weight: bold;
            color: #1a73e8;
            margin-bottom: 0.5rem;
        }
        
        .stat-label {
            color: #5f6368;
            font-size: 1rem;
            font-weight: 500;
        }
        
        .quick-actions {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-top: 2rem;
        }
        
        .quick-actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }
        
        .quick-action-card {
            background: #e8f0fe;
            padding: 1.5rem;
            border-radius: 8px;
            text-align: center;
            text-decoration: none;
            color: #0d47a1;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        
        .quick-action-card:hover {
            background: #1a73e8;
            color: white;
            transform: translateY(-2px);
            border-color: #1a73e8;
        }
        
        .quick-action-card i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            display: block;
        }

        .quick-action-card strong {
            display: block;
            margin-bottom: 0.5rem;
            font-size: 1.1rem;
        }

        .quick-action-card small {
            font-size: 0.9rem;
            opacity: 0.8;
        }

        h1 {
            color: #0d47a1;
            margin-bottom: 0.5rem;
        }

        p {
            color: #5f6368;
            margin-bottom: 1rem;
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            border-left: 4px solid;
        }

        .alert.success {
            background: #f0f9f0;
            color: #155724;
            border-left-color: #34a853;
        }

        .alert.error {
            background: #fdf2f2;
            color: #721c24;
            border-left-color: #ea4335;
        }
    </style>
</head>
<body>
    <nav class="admin-nav">
        <div class="admin-nav-container">
            <div class="nav-logo">
                <a href="index.php" style="color: white; text-decoration: none; font-weight: bold; font-size: 1.2rem;">
                    <i class="fas fa-cog"></i> FantasyVote Admin
                </a>
            </div>
            <div class="admin-menu">
                <a href="index.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <a href="manage-players.php"><i class="fas fa-users"></i> Players</a>
                <a href="manage-coaches.php"><i class="fas fa-user-tie"></i> Coaches</a>
                <a href="manage-voting.php"><i class="fas fa-vote-yea"></i> Voting</a>
                <a href="site-settings.php"><i class="fas fa-cogs"></i> Settings</a>
                <a href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </div>
        </div>
    </nav>
    
    <div class="admin-container">
        <h1>Admin Dashboard</h1>
        <p>Welcome to the FantasyVote administration panel</p>
        
        <div class="stats-grid">
            <?php
            // Get stats
            $total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
            $active_players = $pdo->query("SELECT COUNT(*) FROM players WHERE is_active = TRUE")->fetchColumn();
            $active_coaches = $pdo->query("SELECT COUNT(*) FROM coaches WHERE is_active = TRUE")->fetchColumn();
            $current_game_week_stmt = $pdo->query("SELECT game_week FROM voting_periods WHERE is_active = TRUE LIMIT 1");
            $current_game_week = $current_game_week_stmt->fetchColumn();
            
            // Get total votes statistics
            $total_votes_all = $pdo->query("SELECT COUNT(*) FROM votes")->fetchColumn();
            $total_votes_today = $pdo->query("SELECT COUNT(*) FROM votes WHERE DATE(created_at) = CURDATE()")->fetchColumn();
            $unique_voters = $pdo->query("SELECT COUNT(DISTINCT user_id) FROM votes")->fetchColumn();
            ?>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $total_users; ?></div>
                <div class="stat-label">Total Users</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $total_votes_all; ?></div>
                <div class="stat-label">Total Votes</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $total_votes_today; ?></div>
                <div class="stat-label">Votes Today</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $unique_voters; ?></div>
                <div class="stat-label">Unique Voters</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $active_players; ?></div>
                <div class="stat-label">Active Players</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $active_coaches; ?></div>
                <div class="stat-label">Active Coaches</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo $current_game_week ?: 'None'; ?></div>
                <div class="stat-label">Current Game Week</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?php echo date('Y'); ?></div>
                <div class="stat-label">Current Year</div>
            </div>
        </div>
        
        <div class="quick-actions">
            <h2>Quick Actions</h2>
            <div class="quick-actions-grid">
                <a href="manage-players.php" class="quick-action-card">
                    <i class="fas fa-users"></i>
                    <strong>Manage Players</strong>
                    <small>Add, edit, or remove players</small>
                </a>
                <a href="manage-coaches.php" class="quick-action-card">
                    <i class="fas fa-user-tie"></i>
                    <strong>Manage Coaches</strong>
                    <small>Add, edit, or remove coaches</small>
                </a>
                <a href="manage-voting.php" class="quick-action-card">
                    <i class="fas fa-vote-yea"></i>
                    <strong>Voting Periods</strong>
                    <small>Set active voting periods</small>
                </a>
                <a href="site-settings.php" class="quick-action-card">
                    <i class="fas fa-cogs"></i>
                    <strong>Site Settings</strong>
                    <small>Customize site appearance</small>
                </a>
            </div>
        </div>
    </div>
</body>
</html>